// FxSetDialog.cpp : implementation file
//

#include "stdafx.h"
#include "dt_blockfx.h"
#include "FxSetDialog.h"
#include "BlkFxDialog.h"
#include "Spectrogram.h"
#include "mi_blockfx.h"
#include "blkfx.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(FxSetDialog, CWnd)
	//{{AFX_MSG_MAP(FxSetDialog)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	DT_SLIDER_MSGS(4000, freqCtrl)
	DT_SLIDER_MSGS(4001, fxval)
	DT_SLIDER_MSGS(4002, amp)
	ON_MESSAGE(WM_SETFONT, HandleSetFont)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// FxSetDialog dialog


//------------------------------------------------------------------------------------------
FxSetDialog::FxSetDialog()
{
}

//------------------------------------------------------------------------------------------
FxSetDialog::~FxSetDialog()
{
}

//------------------------------------------------------------------------------------------
void FxSetDialog::init(int _track_number)
{
	track_number = _track_number;
}


//------------------------------------------------------------------------------------------
int FxSetDialog::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	int i;
	if (CWnd::OnCreate(lpCreateStruct) == -1) return -1;

	CRect r; GetClientRect(r);
	freq_ctrl.Create(NULL, NULL, WS_CHILD|WS_VISIBLE|WS_TABSTOP, CRect(0, 0, 250, 38),this,4000);
	freq_ctrl.setIDC(4000);
	freq_ctrl.parentDraw();
	freq_ctrl.setParentInterceptKeys(true);
	for(i = 0; i < 2; i++) {
		freq_ctrl(i).setN(3);
		freq_ctrl(i).setSeparator(" / ");
		freq_ctrl(i).setAppendage(0, "", "Hz");
		freq_ctrl(i).setAppendage(1, "", "");
		freq_ctrl(i).setAppendage(2, "0x", "");
	}
	freq_ctrl(0).setPreLabel("FreqA: ");
	freq_ctrl(1).setPreLabel("FreqB: ");

	fxval_ctrl.Create(NULL, NULL, WS_CHILD|WS_VISIBLE|WS_TABSTOP, CRect(252+18, 0, 500, 18),this,4001);
	fxval_ctrl.setIDC(4001);
	fxval_ctrl.parentDraw();
	fxval_ctrl.setParentInterceptKeys(true);
	fxval_ctrl().setSeparator("");
	fxval_ctrl().setN(2);
	fxval_ctrl().setAppendage(0, "", "-");
	fxval_ctrl().setAppendage(1, "", " : ");

	amp_ctrl.Create(NULL, NULL, WS_CHILD|WS_VISIBLE|WS_TABSTOP, CRect(252, 20, 500, 38),this,4002);
	amp_ctrl.setIDC(4002);
	amp_ctrl.parentDraw();
	amp_ctrl.setParentInterceptKeys(true);
	amp_ctrl().setN(3);
	amp_ctrl().setSeparator(" / ");
	amp_ctrl().setPreLabel("Amp: ");
	amp_ctrl().setAppendage(0, "", "dB");
	amp_ctrl().setAppendage(1, "", "%");
	amp_ctrl().setAppendage(2, "0x", "");

	return 0;
}


//------------------------------------------------------------------------------------------
void FxSetDialog::effectChange(int effect_num, bool send_to_buzz)
//
// set effect number, update effect edits
//
{
	tval->effect = effect_num;

	// change number of params & appendages in the fxval slider

	int desc_table_sz;
	ParamDesc** desc_table;
	BlkFxProcess::getEffectDesc(effect_num, &desc_table_sz, &desc);
	
	fxval_ctrl().setN(num_desc+2/*effect name & number*/);

	// set units for each text edit
	int i;
	for(i = 0; i < desc_table_sz; i++)
		fxval_ctrl().setAppendage(i+2,
			desc[i]->prefix(), desc[i]->postfix()+string(" / "));

	// 
	if(send_to_buzz)
		mi->controlChange(2/*group=tval*/, track_number, effect_num, tvalDisp().effect.get());
}

//------------------------------------------------------------------------------------------
void FxSetDialog::updateControls(
	const TVals& tval_new, bool force)
// buzz has changed value, update controls
{
	if(force || tval_new.effect != tvalDisp().effect)
		effectChange(tval_new.effect, false);

	if(!freq_ctrl.isUserChanging(0))
		freq_ctrl.setVal(0, (float)tvalDisp().freqA/maxBuzzFreqVal());
	if(!freq_ctrl.isUserChanging(1))
		freq_ctrl.setVal(1, (float)tvalDisp().freqB/maxBuzzFreqVal());
	freq_ctrl.redrawControl(force);

	if(!amp_ctrl.isUserChanging())
		amp_ctrl.setVal(TVals::amp_to_frac(tvalDisp().amp));
	amp_ctrl.redrawControl(force);

	if(!fxval_ctrl.isUserChanging())
		fxval_ctrl.setVal(TVals::fxval_to_frac(tvalDisp().fxval));
	fxval_ctrl.redrawControl(force);
}


//------------------------------------------------------------------------------------------
void FxSetDialog::freqCtrlRedraw() 
{
	int i;
	float frac[2];	// 0..1

	// determine display position of knobs
	for(i = 0; i < 2; i++) {
		// display values are rounded based on FFT block size

		void desc(char* txt_out, _FreqParam p, MI_BlockFx& mi) const
			{ sprintf(txt_out, "%.1f", p.getHz(); }

		void param(const char* txt_in, _FreqParam& ret, MI_BlockFx& mi, int trk_num) const
		{
			float percent;
			if(sscanf(txt_in, "%f", &percent)!=1) return;
			ret.setMult(percent/100.0f);
		}
		
		// Hz
		_FreqParam p;
		p.setFrac();
		mi->roundFreqDisp(
			

		mi->pixelToFreq().fracToFreq(freq_ctrl.getVal(i))
		float freq_round = miBlkFx().roundFreqDisp(
			blkfx_dialog->pixelToFreq().pixelFracToFreq(x));

		// value used by Buzz (note*256)
		float val = freq_value_inv(freq_round);

		// fraction 0..1
		frac[i] = val/maxBuzzFreqVal();

		char t[128];
		sprintf(t, "%d", (int)(freq_round+0.5f));
		freq_ctrl(i,0,t); // Hz
		HzToNote(t, freq_round);
		freq_ctrl(i,1,t); // Note
		sprintf(t, "%04x", (int)(val+0.5f));
		freq_ctrl(i,2,t); // raw Buzz
	}

	if(freq_ctrl.chkRedraw(frac)) freq_ctrl.redrawControl_();
}

//------------------------------------------------------------------------------------------
void FxSetDialog::freqCtrlUserChg()
// called from the freq control when it is changed - pass to buzz if it was from the user
{
	for(int i = 0; i < 2; i++) {
		if(freq_ctrl.isUserChanging(i))
			miBlkFx().controlChange(2/*group=tval*/, track_number,
				freqA_enum+i, freq_ctrl.getVal(i)*maxBuzzFreqVal()+0.5f);
	}
}
//------------------------------------------------------------------------------------------
void FxSetDialog::freqCtrlKeyPress()
{
}

//------------------------------------------------------------------------------------------
void FxSetDialog::freqCtrlEditTxtChg()
{
	const char* txt = freq_ctrl().active().getText().c_str();

	float v; // buzz value (256*note)
	switch(freq_ctrl().getActiveN()) {
	case 0: // freq
		{
			float hz;
			if(sscanf(txt, "%f", &hz)!=1) return;
			v = freq_value_inv(hz);
			break;
		}
	case 1: // note
		{
			float hz = NoteToHz(txt);
			if(hz < 0) return;
			v = freq_value_inv(hz);
			break;
		}

	case 2: // hex
		{
			int h;
			if(sscanf(txt, "%x", &h)!=1) return;
			v = h;
			break;
		}
	default: return;
	}
	freq_ctrl.setVal(freq_ctrl.getActive(), v/maxBuzzFreqVal());
}
//------------------------------------------------------------------------------------------
void FxSetDialog::ampUserChg()
{
	miBlkFx().controlChange(2/*group=tval*/, track_number, amp_enum,
			TVals::frac_to_amp(amp_ctrl.getVal()));
}
//------------------------------------------------------------------------------------------
void FxSetDialog::ampRedraw()
{
	// get equiv buzz param
	long v = TVals::frac_to_amp(amp_ctrl.getVal());

	char t[128];
	float scale = amp_value(v);	// linear scale factor

	if(scale > 0.0f) sprintf(t, "%.1f", 20*log10f(scale));
	else strcpy(t, "-inf ");
	amp_ctrl(0, t); // dB
	sprintf(t, "%.1f", scale*100);
	amp_ctrl(1, t); // percent
	sprintf(t, "%02x", v);
	amp_ctrl(2, t); // raw buzz

	if(amp_ctrl.chkRedraw(TVals::amp_to_frac(v))) amp_ctrl.redrawControl_();
}
//------------------------------------------------------------------------------------------
void FxSetDialog::ampKeyPress()
{
}
//------------------------------------------------------------------------------------------
void FxSetDialog::ampEditTxtChg()
{
	float v; // buzz param
	const char* txt = amp_ctrl().active().getText().c_str();
	switch(amp_ctrl().getActiveN()) {
	case 0: // dB
		{
			if(strncmp(txt, "-i", 2)==0) v = 0;
			else {
				float dB;
				if(sscanf(txt, "%f", &dB)!=1) return;
				v = amp_value_inv(powf(10, dB/20));
			}
			break;
		}
	case 1: // percent
		{
			float scale;
			if(sscanf(txt, "%f", &scale)!=1) return;
			v = amp_value_inv(scale*.01f);
			break;
		}

	case 2: // hex
		{
			int h;
			if(sscanf(txt, "%x", &h)!=1) return;
			v = h;
			break;
		}
	default: return;
	}
	amp_ctrl.setVal(TVals::amp_to_frac(v));
}

//------------------------------------------------------------------------------------------
void FxSetDialog::fxvalUserChg()
{
	miBlkFx().controlChange(2/*group=tval*/, track_number, fxval_enum,
		TVals::frac_to_fxval(fxval_ctrl.getVal()) );
	
}

//------------------------------------------------------------------------------------------
void FxSetDialog::fxvalRedraw()
{
	int i;
	char txt[128];
	float v = fxval_ctrl.getVal();
	int effect_num = tvalDisp().effect;
	BlkFx& bf = blkFx(effect_num);

	// fill in the effect number
	sprintf(txt, "%d", effect_num);
	fxval_ctrl(0, txt);

	// fill in the effect name
	bf.name(txt);
	fxval_ctrl(1, txt); 

	// fill in each effect specific param
	for(i = 0; i < bf.getNumberOfDesc(); i++) {
		bf.desc(i, txt, v);
		fxval_ctrl(i+2, txt);
	}

	// redraw the control if it needs it
	if(fxval_ctrl.chkRedraw(TVals::fxval_to_frac(buzz_val))) fxval_ctrl.redrawControl_();
}
	

//------------------------------------------------------------------------------------------
void FxSetDialog::fxvalEditTxtChg()
{
	DtEdit& edit = fxval_ctrl().active();
	const string txt = edit.getText();

	// which edit is being changed?
	int i = fxval_ctrl().getActiveN();
	if(i == 0) {
		// effect number change
		int n;
		if(!sscanf(txt.c_str(), "%d", &n)) return;
		effectChange(n, true);
		return;
	}

	if(i == 1) {
		// effect name change - see what we can match
		if(txt.size() <= 0 || GetKeyState(VK_BACK)&0x80 || GetKeyState(VK_DELETE)&0x80) {
			return;
		}

		// find closest string match
		for(int j = 0; j < miBlkFx().getBlkFxVec().size(); j++) {
			char effect_name[128];
			blkFx(j).name(effect_name);

			if(strncmp(effect_name, txt.c_str(), txt.size()) == 0) {
				// set the text here
				fxval_ctrl().setText(1, effect_name);
				edit.endKey(true);

				// update
				effectChange(j, true);
				break;
			}
		}
		return;
	}

	float v; // 0..1
	BlkFx& bf = blkFx(tvalDisp().effect);

	i -= 2; // adjust for effect number and effect name
	if(i < bf.getNumberOfDesc()) {
		// effect value
		// parse text using specific blkfx method
		v = bf.descToParam(i, txt.c_str(), fxval_ctrl.getVal());
		if(v < 0.0f) return; // check for invalid
	}
	else {
		// last param is hex representation
		int h;
		if(sscanf(txt.c_str(), "%x", &h)!=1) return;
		v = TVals::fxval_to_frac(h);
	}

	fxval_ctrl.setVal(v);
}

//----------------------------------------------------------------------------------------------------
void FxSetDialog::fxvalKeyPress()
{
	int delta;
	switch(fxval_ctrl.currWpWparam()) {
	case VK_UP: delta = 1; break;
	case VK_DOWN: delta = -1; break;
	default: return; // no effect
	}

	DtEdit& edit = fxval_ctrl().active();

	// which edit is being changed?
	int i = fxval_ctrl().getActiveN();
	if(i==0 || i==1) {
		// effect number change
		effectChange(tvalDisp().effect+delta, true);
		return;
	}

	BlkFx& bf = blkFx(tvalDisp().effect);
	fxval_ctrl.setVal( bf.chgValue(i-2, delta, fxval_ctrl.getVal()) );
	fxval_ctrl.redrawControl();
	fxval_ctrl.cancelKeyPress();
}

//----------------------------------------------------------------------------------------------------
LRESULT FxSetDialog::HandleSetFont(WPARAM wParam, LPARAM lParam/*redraw*/)
{
	CFont* font = CFont::FromHandle((HFONT)wParam);
	freq_ctrl.SetFont(font, lParam);
	amp_ctrl.SetFont(font, lParam);
	fxval_ctrl.SetFont(font, lParam);
	return Default();
}
